/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.network.ClientboundSendMessagePacket;
import com.tiviacz.travelersbackpack.util.LogHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class BackpackUtils {
    public static boolean onPlayerDrops(Level level, Player player, ItemStack stack) {
        if (!level.f_46443_) {
            BackpackManager.addBackpack((ServerPlayer)player, stack);
        }
        if (TravelersBackpack.isAnyGraveModInstalled()) {
            return true;
        }
        boolean drop = true;
        if (TravelersBackpackConfig.backpackDeathPlace) {
            drop = TravelersBackpackConfig.backpackForceDeathPlace ? !BackpackUtils.placeBackpack(level, player, player.m_20183_(), stack) : !BackpackUtils.tryPlace(level, player, stack);
        }
        return drop;
    }

    private static boolean placeBackpack(Level level, Player player, BlockPos placePos, ItemStack stack) {
        if (stack.m_41783_() == null) {
            stack.m_41751_(new CompoundTag());
        }
        Block block = Block.m_49814_((Item)stack.m_41720_());
        int y = placePos.m_123342_();
        if (TravelersBackpackConfig.backpackForceDeathPlace) {
            BlockPos targetPos;
            BlockPos playerPos = player.m_20183_();
            y = playerPos.m_123342_();
            if (TravelersBackpackConfig.voidProtection && y <= level.m_141937_()) {
                y = level.m_141937_() + 5;
            }
            for (int i = y; i < level.m_141928_(); ++i) {
                if (!level.m_8055_(new BlockPos(playerPos.m_123341_(), i, playerPos.m_123343_())).m_60795_()) continue;
                y = i;
                break;
            }
            if (level.m_8055_(targetPos = new BlockPos(playerPos.m_123341_(), y, playerPos.m_123343_())).m_60734_().m_7325_() > -1.0f) {
                while (level.m_7702_(targetPos) != null) {
                    targetPos = targetPos.m_7494_();
                }
                if (!level.m_46597_(targetPos, block.m_49966_())) {
                    return false;
                }
                BackpackUtils.placeBackpackInTheWorld(level, player, targetPos, block, stack);
                return true;
            }
            return false;
        }
        if (y <= level.m_141937_() || y >= level.m_141928_()) {
            return false;
        }
        BlockPos targetPos = new BlockPos(placePos.m_123341_(), y, placePos.m_123343_());
        if (!level.m_46597_(targetPos, block.m_49966_())) {
            return false;
        }
        BackpackUtils.placeBackpackInTheWorld(level, player, targetPos, block, stack);
        return true;
    }

    private static void placeBackpackInTheWorld(Level level, Player player, BlockPos targetPos, Block block, ItemStack stack) {
        TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientboundSendMessagePacket(false, targetPos));
        LogHelper.info("Your backpack has been placed at X: " + targetPos.m_123341_() + " Y: " + targetPos.m_123342_() + " Z: " + targetPos.m_123343_(), new Object[0]);
        level.m_6263_(player, (double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), block.m_49966_().m_60827_().m_56777_(), SoundSource.BLOCKS, 0.5f, 1.0f);
        ((TravelersBackpackBlockEntity)level.m_7702_(targetPos)).loadAllData(stack.m_41783_());
        if (stack.m_41788_()) {
            ((TravelersBackpackBlockEntity)level.m_7702_(targetPos)).setCustomName(stack.m_41786_());
        }
        if (CapabilityUtils.isWearingBackpack(player) && !level.f_46443_) {
            CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::removeWearable);
        }
    }

    private static boolean tryPlace(Level level, Player player, ItemStack stack) {
        int[] positions;
        int X = (int)player.m_20185_();
        int Z = (int)player.m_20189_();
        for (int Y : positions = new int[]{0, -1, 1, -2, 2, -3, 3, -4, 4, -5, 5, -6, 6}) {
            BlockPos spawn;
            int y = (int)player.m_20186_();
            if (TravelersBackpackConfig.voidProtection && y <= level.m_141937_()) {
                y = level.m_141937_() + 5;
            }
            if ((spawn = BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, level, X, Z, new BlockPos(X, y + Y, Z), 12, true, 1, (byte)0)) == null) continue;
            return BackpackUtils.placeBackpack(level, player, spawn, stack);
        }
        return false;
    }

    public static String getConvertedTime(int ticks) {
        int i = ticks / 20;
        int minutes = i / 60;
        int seconds = i % 60;
        if (seconds < 10) {
            return minutes + ":0" + seconds;
        }
        return minutes + ":" + seconds;
    }

    public static boolean isShiftPressed() {
        return GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) == 1 || GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344) == 1;
    }

    public static boolean isCtrlPressed() {
        return GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) == 1 || GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)345) == 1;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    public static BlockPos getNearestEmptyChunkCoordinatesSpiral(Player player, Level level, int origX, int origZ, BlockPos pos, int radius, boolean except, int steps, byte pass) {
        int j;
        int i;
        if (steps >= radius) {
            return null;
        }
        if (steps % 2 == 0) {
            if (pass == 0) {
                for (i = pos.m_123341_(); i <= pos.m_123341_() + steps; ++i) {
                    BlockPos blockPos = BackpackUtils.checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new BlockPos(i, pos.m_123342_(), j), radius, except, steps, pass);
            }
            if (pass == 1) {
                for (j = pos.m_123343_(); j >= pos.m_123343_() - steps; --j) {
                    BlockPos blockPos = BackpackUtils.checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new BlockPos(i, pos.m_123342_(), j), radius, except, ++steps, pass);
            }
        }
        if (steps % 2 == 1) {
            if (pass == 0) {
                while (i >= pos.m_123341_() - steps) {
                    BlockPos blockPos = BackpackUtils.checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    --i;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new BlockPos(i, pos.m_123342_(), j), radius, except, steps, pass);
            }
            if (pass == 1) {
                while (j <= pos.m_123343_() + steps) {
                    BlockPos blockPos = BackpackUtils.checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    ++j;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new BlockPos(i, pos.m_123342_(), j), radius, except, ++steps, pass);
            }
        }
        return null;
    }

    public static boolean isTopSolid(Level level, Player player, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60634_((BlockGetter)level, pos.m_7495_(), (Entity)player);
    }

    private static BlockPos checkCoordsForBackpack(Player player, Level level, int origX, int origZ, BlockPos pos, boolean except) {
        if (except && BackpackUtils.isTopSolid(level, player, pos) && (level.m_8055_(pos).m_60795_() || level.m_8055_(pos).m_247087_()) && !BackpackUtils.areCoordinatesTheSame(new BlockPos(origX, pos.m_123342_(), origZ), pos)) {
            return pos;
        }
        if (!except && BackpackUtils.isTopSolid(level, player, pos) && (level.m_8055_(pos).m_60795_() || level.m_8055_(pos).m_247087_())) {
            return pos;
        }
        return null;
    }

    private static boolean areCoordinatesTheSame(BlockPos pos1, BlockPos pos2) {
        return pos1 == pos2;
    }

    public static BlockPos findBlock3D(Level level, int x, int y, int z, Block block, int hRange, int vRange) {
        for (int i = y - vRange; i <= y + vRange; ++i) {
            for (int j = x - hRange; j <= x + hRange; ++j) {
                for (int k = z - hRange; k <= z + hRange; ++k) {
                    if (level.m_8055_(new BlockPos(j, i, k)).m_60734_() != block) continue;
                    return new BlockPos(j, i, k);
                }
            }
        }
        return null;
    }
}

